/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Sender;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private Configuration config;
    private ParseOptions parseOptions = new ParseOptions();

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        if (this.config == null) {
            this.config = new Configuration();
        }
        return this.config;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public void setValidating(boolean state) {
        this.parseOptions.setDTDValidationMode(state ? 1 : 4);
    }

    public boolean isValidating() {
        return this.parseOptions.getDTDValidationMode() == 1;
    }

    public Document newDocument() {
        throw new UnsupportedOperationException("The only way to build a document using this DocumentBuilder is with the parse() method");
    }

    public Document parse(InputSource in) throws SAXException {
        try {
            if (this.config == null) {
                this.config = new Configuration();
            }
            TinyBuilder builder = new TinyBuilder(this.config.makePipelineConfiguration());
            SAXSource source = new SAXSource(in);
            source.setSystemId(in.getSystemId());
            Sender.send(source, builder, this.parseOptions);
            TinyDocumentImpl doc = (TinyDocumentImpl)builder.getCurrentRoot();
            ((Builder)builder).reset();
            return (Document)((Object)DocumentOverNodeInfo.wrap(doc));
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public Document parse(File f) throws SAXException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        String uri = f.toURI().toString();
        InputSource in = new InputSource(uri);
        return this.parse(in);
    }

    public void setEntityResolver(EntityResolver er) {
        this.parseOptions.setEntityResolver(er);
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.parseOptions.setErrorHandler(eh);
    }

    public DOMImplementation getDOMImplementation() {
        return this.newDocument().getImplementation();
    }

    public void setXIncludeAware(boolean state) {
        this.parseOptions.setXIncludeAware(state);
    }

    public boolean isXIncludeAware() {
        return this.parseOptions.isXIncludeAware();
    }

    public void setStripSpace(int stripAction) {
        this.parseOptions.setStripSpace(stripAction);
    }

    public int getStripSpace() {
        return this.parseOptions.getStripSpace();
    }

    public void setParseOptions(ParseOptions options) {
        this.parseOptions = options;
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }
}

