# Generated by default/object.tt
package Paws::SSOAdmin::AccessControlAttribute;
  use Moose;
  has Key => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Paws::SSOAdmin::AccessControlAttributeValue', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSOAdmin::AccessControlAttribute

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSOAdmin::AccessControlAttribute object:

  $service_obj->Method(Att1 => { Key => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSOAdmin::AccessControlAttribute object:

  $result = $service_obj->Method(...);
  $result->Att1->Key

=head1 DESCRIPTION

These are AWS SSO identity store attributes that you can configure for
use in attributes-based access control (ABAC). You can create
permission policies that determine who can access your AWS resources
based upon the configured attribute value(s). When you enable ABAC and
specify AccessControlAttributes, AWS SSO passes the attribute(s) value
of the authenticated user into IAM for use in policy evaluation.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Key => Str

The name of the attribute associated with your identities in your
identity source. This is used to map a specified attribute in your
identity source with an attribute in AWS SSO.


=head2 B<REQUIRED> Value => L<Paws::SSOAdmin::AccessControlAttributeValue>

The value used for mapping a specified attribute to an identity source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSOAdmin>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

